#ifndef _PLAYER_H__
#define _PLAYER_H__

#include <cmath>
#include "sprig.h"
#include "Libraries/SDL_ColorDef.h"
#include "Libraries/Animation.h"

class GameState;

class House
{
    public:
    float x, y;
    float radius;
    float hp;
    SDL_Surface* pic;
    
    House(float x, float y);
    ~House();
    
    void update(GameState* state, float dt);
    
    void draw(SDL_Surface* screen);
};

class Fire
{
    public:
    float x, y;
    float velx, vely;
    float speed;
    float size;
    float burnTimer;
    float spawnTimer;
    float growthFactor;
    float deathFactor;
    bool isWild;
    float maxSize;
    
    ASAnimation anim;
    
    Fire(float x, float y);
    Fire(const Fire& fire);
    ~Fire();
    
    void update(GameState* state, float dt);
    
    void updateEffects(GameState* state, float dt);
    
    void draw(SDL_Surface* screen);
};


class Player
{
    public:
    float x, y;
    float velx, vely;
    float accx, accy;
    
    bool burning;
    float burnTimer;
    
    float hp;
    
    int direction;
    ASAnimation animRight, animUp, animLeft, animDown;
    
    Player(bool bonus = false);
    ~Player();
    
    void update(GameState* state, float dt);
    
    void updateEffects(GameState* state, float dt);
    
    void draw(SDL_Surface* screen);
    void drawAim(GameState* state, float x, float y);
    void drawLife(GameState* state);
    
    void moveUp();
    void moveDown();
    void moveLeft();
    void moveRight();
    void stopUp();
    void stopDown();
    void stopLeft();
    void stopRight();
    
    void startBurn(GameState* state, float x, float y);
    void continueBurn(GameState* state, float x, float y);
    void addFire(GameState* state, float x, float y);
    void endBurn();
};



#endif
